/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright (c) 2015 Adobe Systems Incorporated. All rights reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */

/*jslint vars: true, node: true, plusplus: true, devel: true, nomen: true, indent: 4, expr:true */
/*global beforeEach: false, afterEach: false, it: false, describe: false, expect: false*/

"use strict";

var sinon = require("sinon"),
    Locale = require("locale");

describe("Locale", function () {
    var sandbox = sinon.sandbox.create();

    afterEach(function () {
        sandbox.restore();
    });

    it("loads the en_US locale", function() {
        Locale.init("en_US");
        expect(Locale.CANCEL).to.equal("Cancel");
    });

    it("loads a non-en_US locale", function() {
        Locale.init("es_ES");
        expect(Locale.CANCEL).to.equal("Cancelar");
    });

    it("loads a locale with non-latin characters", function() {
        Locale.init("zh_CN");
        expect(Locale.CANCEL).to.equal("取消");
    });

    it("falls back to en_US and logs an error when locale is unrecognized", function() {
        sandbox.stub(console, "error");

        var badLocale = "not a locale";
        Locale.init(badLocale);
        expect(Locale.CANCEL).to.equal("Cancel");
        expect(console.error).to.be.calledOnce.and.to.be.calledWith("Failed to load locale:", badLocale);
    });

    it("logs an error when it couldn't load the fallback url", function() {
        sandbox.stub(console, "error");
        sandbox.stub(Locale, "_loadLocaleStrings").returns(null);

        var badLocale = "not a locale";
        Locale.init(badLocale);
        expect(Locale.CANCEL).to.equal("Cancel");
        expect(console.error).to.be.calledOnce.and.to.be.calledWith("Failed to load fallback locale.");
    });

    it("parses strings with multiple words correctly", function () {
        Locale.init("en_US");
        expect(Locale.SELECT_ALL).to.equal("Select All");
    });
});
